<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class ContactFormController extends Controller
{
    public function submitForm(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone_number' => 'required',
            'msg_subject' => 'required',
            'message' => 'required',
        ]);

        // Send email
        Mail::send([], [], function ($message) use ($validatedData) {
            $message->to('contactus@jayprime.com')
                ->subject($validatedData['msg_subject'])
                ->setBody("
                    Name: {$validatedData['name']}
                    Email: {$validatedData['email']}
                    Phone: {$validatedData['phone_number']}
                    Message: {$validatedData['message']}
                ");
        });
        return redirect()->back()->with('success', 'Message sent successfully!');
    }
}
